-- Gameplay overlay.
-- contains the following:
-- * life meter
-- * progress meter
-- * dance point meter
-- * song info
-- * player mods
-- * song number (course modes only)
-- and nothing else. :)

-- PlayerOptions(pn)
-- Returns a text actor with the specified player options.
local function PlayerOptions(pn)
	return LoadFont("_frutiger lt std 55 roman 24px")..{
		InitCommand=cmd(zoom,0.6;shadowlength,1;maxwidth,SCREEN_WIDTH/2);
		BeginCommand=function(self)
			if pn == PLAYER_1 then self:horizalign(left);
			else self:horizalign(right);
			end;
			
			if GAMESTATE:IsSideJoined(pn) or GAMESTATE:IsPlayerEnabled(pn) or GAMESTATE:IsDemonstration() then
				self:visible(true);
			else self:visible(false);
			end;
			
			-- then do my other dumb check!
			if GetDisplayModsOption() == "true" then self:visible(true);
			else self:visible(false);
			end;
		end;
		OnCommand=function(self)
			if not self:GetVisible() then return; end;
			local proxy;
			if pn == PLAYER_1 then
				proxy = SCREENMAN:GetTopScreen():GetChild('PlayerOptionsP1');
			else
				proxy = SCREENMAN:GetTopScreen():GetChild('PlayerOptionsP2');
			end;
			if proxy then
				local modlist = proxy:GetText();
				self:settext(modlist);
			else
				self:settext("");
			end;
		end;
	};
end;

-- Difficulty(pn)
-- Returns a text actor with the specified difficulty.
local function Difficulty(pn)
	local r = Def.ActorFrame{};
	
	r[#r+1] = Def.Quad{
		InitCommand=function(self)
			local fadeAmt = 0.25;
			
			if pn == PLAYER_1 then
				self:addx(-4);
				self:horizalign(left);
				self:faderight(fadeAmt);
			else
				self:horizalign(right);
				self:addx(4);
				self:fadeleft(fadeAmt);
			end;
			
			self:addy(1);
			
			self:zoomx(96);
			self:zoomy(18);
			if pn then
				-- [v1.4] fix up difficulty display for course mode
				local pm = GAMESTATE:GetPlayMode();
				if pm == "PlayMode_Nonstop" or pm == "PlayMode_Endless" then
					self:diffuse( DifficultyDarkColor( GAMESTATE:GetCurrentTrail(pn):GetDifficulty() ) );
				else
					self:diffuse( DifficultyDarkColor( GAMESTATE:GetCurrentSteps(pn):GetDifficulty() ) );
				end
			end;
			self:diffusealpha(0.5);
		end;
		BeginCommand=function(self)
			if GAMESTATE:IsSideJoined(pn) or GAMESTATE:IsPlayerEnabled(pn) or GAMESTATE:IsDemonstration() then
				self:visible(true)
			else self:visible(false);
			end;
		end;
	};
	
	r[#r+1] = LoadFont("_frutiger lt std 55 roman 24px")..{
		Name="Difficulty"..pn;
		InitCommand=cmd(zoom,0.6;shadowlength,1);
		BeginCommand=function(self)
			if GAMESTATE:IsSideJoined(pn) or GAMESTATE:IsPlayerEnabled(pn) or GAMESTATE:IsDemonstration() then
				self:visible(true)
			else self:visible(false);
			end;
			
			if pn == PLAYER_1 then self:horizalign(left);
			else self:horizalign(right);
			end;
			
		end;
		OnCommand=function(self)
			if not self:GetVisible() then return; end;
			-- get difficulty
			local steps = GAMESTATE:GetCurrentSteps(pn);
			local difficulty = steps:GetDifficulty();
			local diffString = ( string.sub(difficulty,12) );
			self:diffuse( DifficultyColor(difficulty) );
			self:settext(diffString .. " [" ..steps:GetMeter().."]");
			self:diffusetopedge( color("#FFFFFF") );
		end;
	};
	
	return r;
end;

-- SongNumber(pn)
-- Returns a text actor with the current song number.
local function SongNumber(pn)
	return LoadFont("_frutiger lt std 55 roman 24px")..{
		InitCommand=cmd(shadowlength,1);
		BeginCommand=function(self)
			if pn == PLAYER_1 then self:horizalign(right);
			else self:horizalign(left);
			end;
			
			-- [v1.4] make the number a different color in endless
			local pm = GAMESTATE:GetPlayMode();
			if pm == "PlayMode_Endless" then
				self:diffuse( color("1,0.796,0.398,1") );	-- gold
			else
				self:diffuse( color("1,1,1,1") );			-- white
			end;
			
			if (GAMESTATE:IsSideJoined(pn) or GAMESTATE:IsPlayerEnabled(pn)) then
				self:visible(true);
			else
				self:visible(false);
			end;
			
			self:playcommand("Update");
		end;
		
		UpdateCommand=function(self)
			if not GAMESTATE:IsCourseMode() then return; end;
			local proxy;
			if pn == PLAYER_1 then
				proxy = SCREENMAN:GetTopScreen():GetChild('SongNumberP1');
			else
				proxy = SCREENMAN:GetTopScreen():GetChild('SongNumberP2');
			end;
			if proxy then self:settext( proxy:GetText() ); end;
		end;
		
		CurrentSongChangedMessageCommand=cmd(playcommand,"Update");
	};
end;

local t = Def.ActorFrame{
	-- thanks shake
	Def.ActorFrame{
		Name="SongMeter";
		InitCommand=cmd(x,SCREEN_CENTER_X;y,SCREEN_TOP-10);
		OnCommand=cmd(decelerate,0.2;addy,15);
		OffCommand=cmd(accelerate,0.2;addy,-15);
		
		LoadActor( THEME:GetPathB("","_frame 3x1"), "_progress", SCREEN_WIDTH-8);
		
		Def.SongMeterDisplay {
			StreamWidth=SCREEN_WIDTH;
			
			Stream=Def.Quad {
				InitCommand=cmd(zoomy,6;diffuse,color("#fff226");diffusebottomedge,color("#ffcc00"));
			};
			
			Tip=Def.Quad{
				InitCommand=cmd(zoomto,2,6;diffusebottomedge,color("#cccccc"));
			};
		};
	};
	
	-- song info
	Def.ActorFrame{
		Name="SongInfoFrame";
		InitCommand=cmd(x,SCREEN_CENTER_X;y,SCREEN_TOP+54;playcommand,"Update");
		
		LoadFont("_frutiger lt std 55 roman 24px")..{
			Name="TheInfo";
			InitCommand=cmd(zoom,0.6;shadowlength,1;maxwidth,SCREEN_WIDTH-32);
			
			BeginCommand=function(self)
				if GetSongTitleOption() == "true" then self:visible(true);
				else self:visible(false);
				end;
			end;
			
			OffCommand=cmd(linear,0.2;diffusealpha,0);
			
			CurrentSongChangedMessageCommand=cmd(playcommand,"Update");
			
			UpdateCommand=function(self)
				local title;
				local artist;
				local song = GAMESTATE:GetCurrentSong();
				
				if song then
					if GAMESTATE:IsCourseMode() then
						title = GAMESTATE:GetCurrentCourse():GetDisplayFullTitle();
						artist = song:GetDisplayFullTitle();
						--artist = "";
					else
						title = song:GetDisplayFullTitle();
						artist = song:GetDisplayArtist();
					end;
				else
					title = "???";
					artist = "???";
				end;
				self:settext(title .." / ".. artist);
			end;
		};
	};
	
	-- p1 life
	LoadActor("lifemeter",PLAYER_1)..{
		InitCommand=cmd(x,SCREEN_CENTER_X/2;y,SCREEN_TOP+28);
		BeginCommand=function(self)
			if GAMESTATE:GetPlayMode() == 'PlayMode_Oni' then self:visible(false);
			else self:visible(true);
			end;
		end;
	};
	-- p1 mods
	PlayerOptions(PLAYER_1)..{
		Name="P1Mods";
		InitCommand=cmd(x,SCREEN_LEFT+4;y,SCREEN_BOTTOM-28);
		OffCommand=cmd(linear,0.2;diffusealpha,0);
	};
	-- p1 difficulty
	Difficulty(PLAYER_1)..{
		Name="P1Difficulty";
		InitCommand=cmd(x,SCREEN_LEFT+4;y,SCREEN_TOP+54);
		OffCommand=cmd(linear,0.2;diffusealpha,0);
	};
	-- p1 song number
	SongNumber(PLAYER_1)..{
		Name="P1SongNum";
		InitCommand=cmd(x,SCREEN_CENTER_X-12;y,SCREEN_TOP+26);
		OffCommand=cmd(linear,0.2;diffusealpha,0);
	};
	
	-- p2 life
	LoadActor("lifemeter",PLAYER_2)..{
		InitCommand=cmd(x,SCREEN_CENTER_X*1.5;y,SCREEN_TOP+28);
		BeginCommand=function(self)
			if GAMESTATE:GetPlayMode() == 'PlayMode_Oni' then self:visible(false);
			else self:visible(true);
			end;
		end;
	};
	-- p2 mods
	PlayerOptions(PLAYER_2)..{
		Name="P2Mods";
		InitCommand=cmd(x,SCREEN_RIGHT-4;y,SCREEN_BOTTOM-28);
		OffCommand=cmd(linear,0.2;diffusealpha,0);
	};
	-- p2 difficulty
	Difficulty(PLAYER_2)..{
		Name="P2Difficulty";
		InitCommand=cmd(x,SCREEN_RIGHT-4;y,SCREEN_TOP+54);
		OffCommand=cmd(linear,0.2;diffusealpha,0);
	};
	-- p2 song number
	SongNumber(PLAYER_2)..{
		Name="P2SongNum";
		InitCommand=cmd(x,SCREEN_CENTER_X+12;y,SCREEN_TOP+26);
		OffCommand=cmd(linear,0.2;diffusealpha,0);
	};
};

return t;
-- minimal is bliss. -aj